// JavaScript
// Panel creator

/* jshint esversion:6, -W097 */
/* jslint esversion:6 */
/* global GrammalectePanel, oGrammalecte, xGrammalectePort, showError, window, document, console */

"use strict";


class GrammalectePanel {

    constructor (sId, sTitle, nWidth, nHeight, bFlexible=true) {
        this.sId = sId;
        this.nWidth = nWidth;
        this.nHeight = nHeight;
        this.bFlexible = bFlexible;
        this.bWorking = false;

        this.bShadow = document.body.createShadowRoot || document.body.attachShadow;
        if (this.bShadow) {
            this.xShadowPanel = oGrammalecte.createNode("div", {id: this.sId+"_shadow", style: "width:0;height:0;"});
            this.xShadow = this.xShadowPanel.attachShadow({mode: "open"});
            this.xParent = this.xShadow;
        } else {
            this.xParent = document;
        }

        this.xPanelBar = oGrammalecte.createNode("div", {className: "grammalecte_panel_bar"});
        this.xPanelContent = oGrammalecte.createNode("div", {className: "grammalecte_panel_content"});
        this.xWaitIcon = this._createWaitIcon();
        this.xCloseButton = null;
        this.xPanel = this._createPanel(sTitle);
        this.center();
    }

    _createPanel (sTitle) {
        try {
            let xPanel = oGrammalecte.createNode("div", {id: this.sId, className: "grammalecte_panel"});
            this.xPanelBar.appendChild(oGrammalecte.createNode("div", {className: "grammalecte_panel_invisible_marker", textContent: "__grammalecte_panel__"}));
            this.xPanelBar.appendChild(this._createButtons());
            let xTitle = oGrammalecte.createNode("div", {className: "grammalecte_panel_title"});
            xTitle.appendChild(this._createLogo());
            xTitle.appendChild(oGrammalecte.createNode("div", {className: "grammalecte_panel_label", textContent: sTitle}));
            this.xPanelBar.appendChild(xTitle);
            xPanel.appendChild(this.xPanelBar);
            this._createMesssageBlock();
            xPanel.appendChild(this.xPanelMessageBlock);
            xPanel.appendChild(this.xPanelContent);
            return xPanel;
        }
        catch (e) {
            showError(e);
        }
    }

    _createLogo () {
        let xImg = document.createElement("img");
        xImg.src = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAA3XAAAN1wFCKJt4AAAC8UlEQVQ4jX3TbUgTcRwH8P89ddu5u9tt082aZmpFEU4tFz0QGTUwCi0heniR9MSUIKRaD0RvIlKigsooo+iNFa0XJYuwIjEK19OcDtPElsG0ktyp591t7u7+vUh7MPX3+vf5/n8/+P0BmKJIPUUVlh2rdVVeesWlzEybqg+bFOsoylnqPmNavGFfknV2Omu2Lvja3vxAURKJib3opHizu8riLK6gjRyuKgmoSoMRFENRUqfXTzvBGK62LC2uoFkOl4RhjQ8+qWt7dPNE3sbdp+2LXbsGe9qb4rIo/BfwFy6nWQ4ThWGNDzbcfu29dMDh2nHU7CypYNLmzTda0/L5cNuzmDQi/A4Y27k6eQxLI79wS/11D0AAMNvs6XT6ojVJjJEgTbMy2BT77xBMp09KcpaWV1uc41jQoi0NdUHfjeOO9WWn7AVF7s7n986SithPJGeupBh2PCSP/xxqxAp3eq6wuUV7Wc6MSZIEhA8vHjbfOe/OcW3zmAuKy+nUzAyD2bow8ODaEROFq8AyZ5WBYdEZXGqGxZ61HJV+9HYCJRbTNA0QBA40HWunaKN5dKg/DBKxeCIe09Th/m4MJwiMSZmLEzMQAABQRuNqgu8NYX3doTcMpvCkLbtQZ2AJkrPOZG1zlnY13T+Hy9EehY90h57eqcorcZ/lctZuMzAsOjLEqwNv66/6vZcPYRBC+C3cGaBxhSet2av1BpYgTTY7k5y2JPT41slIR6Axv8R9nnOs+4Pf+2r992uOxGVJwgAAAEINfgt3BGgsESWtWas1iGDyl+CT/u7WpvxNFRc4x7qtBoZFhSFejb7z1fq9NYfjsiT+cwcQavBruCOgU4SIGo18amuoq3Js3FNlynVtH385+s53ze+t8cRkURx3yMTTRBAEQVAUXbFlf3XystJKA2NExeFBdWASDAAA+MQACCEEmqbJ0b6PMC7JwhDU8YFHV5u9NZ64LErT/oW/63tPV6uJwmKoOND78u7Fg5NhAAD4CVbzY9cwrWQrAAAAAElFTkSuQmCC";
        return xImg;
    }

    _createButtons () {
        let xButtonLine = oGrammalecte.createNode("div", {className: "grammalecte_panel_commands"});
        xButtonLine.appendChild(this.xWaitIcon);
        if (this.sId === "grammalecte_gc_panel") {
            xButtonLine.appendChild(this._createCopyButton());
        }
        xButtonLine.appendChild(this._createMoveButton("stickToTop", "⏶", "Coller en haut"));
        xButtonLine.appendChild(this._createMoveButton("stickToLeft", "⏴", "Coller à gauche"));
        xButtonLine.appendChild(this._createMoveButton("center", "•", "Centrer"));
        xButtonLine.appendChild(this._createMoveButton("stickToRight", "⏵", "Coller à droite"));
        xButtonLine.appendChild(this._createMoveButton("stickToBottom", "⏷", "Coller en bas"));
        this.xCloseButton = this._createCloseButton();
        xButtonLine.appendChild(this.xCloseButton);
        return xButtonLine;
    }

    _createWaitIcon () {
        let xWaitIcon = oGrammalecte.createNode("div", {className: "grammalecte_spinner"});
        return xWaitIcon;
    }

    _createCopyButton () {
        let xButton = oGrammalecte.createNode("div", {id: "grammalecte_clipboard_button", className: "grammalecte_panel_button grammalecte_copy_button", textContent: "📋", title: "Copier le contenu de l’éditeur dans le presse-papiers"});
        xButton.onclick = () => { this.copyTextToClipboard(); };
        return xButton;
    }

    _createMoveButton (sAction, sLabel, sTitle) {
        let xButton = oGrammalecte.createNode("div", {className: "grammalecte_panel_button grammalecte_move_button", textContent: sLabel, title: sTitle});
        xButton.onclick = () => { this[sAction](); };
        return xButton;
    }

    _createCloseButton () {
        let xButton = oGrammalecte.createNode("div", {className: "grammalecte_panel_button grammalecte_close_button", textContent: "×", title: "Fermer la fenêtre"});
        xButton.onclick = () => { this.hide(); };
        return xButton;
    }

    _createMesssageBlock () {
        this.xPanelMessageBlock = oGrammalecte.createNode("div", {id: "grammalecte_panel_message_block"});
        let xPanelMessageCloseButton = oGrammalecte.createNode("div", {id: "grammalecte_panel_message_close_button", textContent: "×"});
        xPanelMessageCloseButton.onclick = () => { this.hideMessage() };
        this.xPanelMessageBlock.appendChild(xPanelMessageCloseButton);
        this.xPanelMessage = oGrammalecte.createNode("div", {id: "grammalecte_panel_message"});
        this.xPanelMessageBlock.appendChild(this.xPanelMessage);
    }

    insertIntoPage () {
        if (this.bShadow) {
            oGrammalecte.createStyle("content_scripts/panel.css", null, this.xShadow);
            oGrammalecte.createStyle("content_scripts/panel_gc.css", null, this.xShadow);
            oGrammalecte.createStyle("content_scripts/panel_lxg.css", null, this.xShadow);
            oGrammalecte.createStyle("content_scripts/panel_conj.css", null, this.xShadow);
            oGrammalecte.createStyle("content_scripts/panel_tf.css", null, this.xShadow);
            this.xShadow.appendChild(this.xPanel);
            document.body.appendChild(this.xShadowPanel);
        } else {
            if (!document.getElementById("grammalecte_csspanel")) {
                oGrammalecte.createStyle("content_scripts/panel.css", "grammalecte_csspanel", document.head);
                oGrammalecte.createStyle("content_scripts/panel_gc.css", null, document.head);
                oGrammalecte.createStyle("content_scripts/panel_lxg.css", null, document.head);
                oGrammalecte.createStyle("content_scripts/panel_conj.css", null, document.head);
                oGrammalecte.createStyle("content_scripts/panel_tf.css", null, document.head);
            }
            document.body.appendChild(this.xPanel);
        }
    }

    show () {
        this.xPanel.style.display = "flex";
    }

    hide () {
        this.xPanel.style.display = "none";
    }

    center () {
        let nHeight = (this.bFlexible) ? window.innerHeight-100 : this.nHeight;
        this.setSizeAndPosition(`${this.nWidth}px`, `${nHeight}px`, "50%", "", "", "50%", `-${nHeight/2}px`, `-${this.nWidth/2}px`);
    }

    stickToLeft () {
        let nHeight = (this.bFlexible) ? window.innerHeight-100 : this.nHeight;
        this.setSizeAndPosition(`${this.nWidth}px`, `${nHeight}px`, "50%", "", "", "-2px", `-${nHeight/2}px`, "");
    }

    stickToRight () {
        let nHeight = (this.bFlexible) ? window.innerHeight-100 : this.nHeight;
        this.setSizeAndPosition(`${this.nWidth}px`, `${nHeight}px`, "50%", "-2px", "", "", `-${nHeight/2}px`, "");
    }

    stickToTop () {
        let nWidth = (this.bFlexible) ? Math.floor(window.innerWidth/2) : this.nWidth;
        let nHeight = (this.bFlexible) ? Math.floor(window.innerHeight*0.45) : this.nHeight;
        this.setSizeAndPosition(`${nWidth}px`, `${nHeight}px`, "-2px", "", "", "50%", "", `-${nWidth/2}px`);
    }

    stickToBottom () {
        let nWidth = (this.bFlexible) ? Math.floor(window.innerWidth/2) : this.nWidth;
        let nHeight = (this.bFlexible) ? Math.floor(window.innerHeight*0.45) : this.nHeight;
        this.setSizeAndPosition(`${nWidth}px`, `${nHeight}px`, "", "", "-2px", "50%", "", `-${nWidth/2}px`);
    }

    setSizeAndPosition (sWidth, sHeight, sTop, sRight, sBottom, sLeft, sMarginTop, sMarginLeft) {
        this.xPanel.style.width = sWidth;
        this.xPanel.style.height = sHeight;
        this.xPanel.style.top = sTop;
        this.xPanel.style.right = sRight;
        this.xPanel.style.bottom = sBottom;
        this.xPanel.style.left = sLeft;
        this.xPanel.style.marginTop = sMarginTop;
        this.xPanel.style.marginLeft = sMarginLeft;
    }

    reduce () {
        // todo
    }

    getWidth () {
        return this.xPanelContent.offsetWidth;
    }

    logInnerHTML () {
        // for debugging
        console.log(this.xPanel.innerHTML);
    }

    startWaitIcon () {
        this.bWorking = true;
        this.xWaitIcon.style.visibility = "visible";
    }

    stopWaitIcon () {
        this.bWorking = false;
        this.xWaitIcon.style.visibility = "hidden";
    }

    showMessage (sMessage) {
        this.xPanelMessageBlock.style.display = "block";
        this.xPanelMessage.textContent = sMessage;
    }

    hideMessage () {
        this.xPanelMessageBlock.style.display = "none";
    }

    openURL (sURL) {
        xGrammalectePort.postMessage({
            sCommand: "openURL",
            dParam: {"sURL": sURL},
            dInfo: {}
        });
    }
}
